<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\EntityRepository;
use Gedmo\Mapping\Annotation as Gedmo;

class SummaryCompanyRoundRepository extends EntityRepository
{
    /*
     * find notes and content for user
     */
    public function findLastForUser($userId)
    {
        $QueryBuilder = $this->createQueryBuilder('s')
            ->select('s.roundId')
            ->leftJoin('s.company','c')
            ->leftJoin('c.userGroups','u')
            ->where('u.user_id = :user')
            ->setParameter('user',$userId)
            ->orderBy('s.roundId','DESC')
            ->setMaxResults(1)
        ;
        $maxRound = $QueryBuilder->getQuery()->getScalarResult();

        $QueryBuilder = $this->createQueryBuilder('s')
            ->select('s')
            ->leftJoin('s.company','c')
            ->leftJoin('c.userGroups','u')
            ->andwhere('u.user_id = :user')
            ->setParameter('user',$userId)
            ->andwhere('s.roundId = :round')
            ->setParameter('round',$maxRound)
        ;

        return $QueryBuilder->getQuery()->getResult();
    }
}